#include "peer_connection_established_state.h"

using namespace messenger::rtc;

const std::string SessionStateMachine::PeerConnectionEstablishedState::NAME = "PeerConnectionEstablishedState";

SessionStateMachine::PeerConnectionEstablishedState::PeerConnectionEstablishedState(SessionStateMachine* machine)
    : NegotiatingState(machine)
{
}

void SessionStateMachine::PeerConnectionEstablishedState::enter() {
    NegotiatingState::enter();

    machine_->status_ = MediaSession::Status::CONNECTED;
    machine_->notifyStatusChange(MediaSession::Status::CONNECTED);

    // TODO: network observer --> PeerConnectionBrokenState

    machine_->mediator_->updateMediaState(machine_->sessionUuid_, true, false);
}

void SessionStateMachine::PeerConnectionEstablishedState::exit() {
    NegotiatingState::exit();
}
