#include "ready_for_negotiation_state.h"

#include "local_offer_creating_state.h"
#include "remote_offer_receiving_state.h"

#include <memory>

using namespace messenger::rtc;

const std::string SessionStateMachine::ReadyForNegotiationState::NAME = "ReadyForNegotiationState";

SessionStateMachine::ReadyForNegotiationState::ReadyForNegotiationState(SessionStateMachine* machine, bool performIceRestart)
    : SessionState(machine)
    , performIceRestart_(performIceRestart)
{
}

void SessionStateMachine::ReadyForNegotiationState::enter() {
    machine_->status_ = MediaSession::Status::CONNECTING;
    machine_->notifyStatusChange(MediaSession::Status::CONNECTING);

    if (machine_->direction_ == Direction::OUTGOING) {
        machine_->setState(std::make_unique<LocalOfferCreatingState>(machine_, performIceRestart_));

    } else {
        machine_->setState(std::make_unique<RemoteOfferReceivingState>(machine_));
    }
}

void SessionStateMachine::ReadyForNegotiationState::exit() {
}
