#pragma once

#include "negotiating_state.h"

#include <yandex_io/callkit/rtc/media/session_state_machine.h>

#include <yandex_io/callkit/rtc/utils/timer.h>

namespace messenger {
    namespace rtc {

        class SessionStateMachine::RemoteAnswerReceivingState
            : public SessionStateMachine::NegotiatingState {
        public:
            RemoteAnswerReceivingState(SessionStateMachine* machine,
                                       const std::string& sdp);

            void enter() override;

            void exit() override;

            static const std::string NAME;

            const std::string& name() const override {
                return NAME;
            }

            bool negotiatingLocalOffer() const override {
                return true;
            }

        private:
            void handleRemoteAnswer(const MediatorApi::Message& message);

        private:
            const std::string sdp_;
            MediatorApi::MessageSubscription subscription_;

            std::shared_ptr<Timer> timer_;
        };

    } // namespace rtc
} // namespace messenger
