#pragma once

#include "negotiating_state.h"

#include <yandex_io/callkit/rtc/media/session_state_machine.h>

namespace messenger {
    namespace rtc {

        class SessionStateMachine::RemoteAnswerSettingState: public SessionStateMachine::NegotiatingState {
        public:
            RemoteAnswerSettingState(SessionStateMachine* machine, const std::string& sdp);

            void enter() override;

            void exit() override;

            static const std::string NAME;

            const std::string& name() const override {
                return NAME;
            }

        private:
            class Observer: public webrtc::SetSessionDescriptionObserver {
            public:
                Observer(SessionStateMachine* machine)
                    : machine_(machine)
                {
                }

                void OnSuccess() override;

                void OnFailure(webrtc::RTCError error) override;

                void enter() {
                    inState_ = true;
                }

                void exit() {
                    inState_ = false;
                }

            private:
                SessionStateMachine* machine_;

                bool inState_;
            };

        private:
            const std::string sdp_;

            ::rtc::scoped_refptr<Observer> observer_;
        };

    } // namespace rtc
} // namespace messenger
