#include "remote_offer_receiving_state.h"

#include "remote_offer_setting_state.h"

#include <memory>

using namespace messenger::rtc;

const std::string SessionStateMachine::RemoteOfferReceivingState::NAME = "RemoteOfferReceivingState";

SessionStateMachine::RemoteOfferReceivingState::RemoteOfferReceivingState(SessionStateMachine* machine)
    : NegotiatingState(machine)
{
}

void SessionStateMachine::RemoteOfferReceivingState::enter() {
    NegotiatingState::enter();

    subscription_ = machine_->mediator_->subscribe([this](const MediatorApi::Message& message) {
        if (message.get("method", "") == "offer") {
            if (!message.isMember("params")) {
                return;
            }

            const auto& params = message["params"];

            if (!params.isMember("guid")) {
                return;
            }

            const std::string& guid = params["guid"].asString();

            if (guid != machine_->sessionUuid_) {
                return;
            }

            machine_->mediator_->acknowledge(guid, message["id"].asString());

            if (!params.isMember("offer")) {
                return;
            }

            const std::string& offer = params["offer"].asString();

            machine_->setState(std::make_unique<RemoteOfferSettingState>(machine_, offer));
        }
    });
}

void SessionStateMachine::RemoteOfferReceivingState::exit() {
    subscription_.reset(nullptr);

    NegotiatingState::exit();
}
