#pragma once

#include "negotiating_state.h"

namespace messenger {
    namespace rtc {

        class SessionStateMachine::RemoteOfferReceivingState: public SessionStateMachine::NegotiatingState {
        public:
            explicit RemoteOfferReceivingState(SessionStateMachine* machine);

            void enter() override;

            void exit() override;

            static const std::string NAME;

            const std::string& name() const override {
                return NAME;
            }

            bool shouldSkipRenegotiation() const override {
                return true;
            }

        private:
            MediatorApi::MessageSubscription subscription_;
        };

    } // namespace rtc
} // namespace messenger
