#pragma once

#include "negotiating_state.h"

namespace messenger {
    namespace rtc {

        class SessionStateMachine::RemoteOfferSettingState
            : public SessionStateMachine::NegotiatingState {
        public:
            RemoteOfferSettingState(SessionStateMachine* machine,
                                    const std::string& offer);

            void enter() override;

            void exit() override;

            static const std::string NAME;

            const std::string& name() const override {
                return NAME;
            }

            bool shouldSkipRenegotiation() const override {
                return true;
            }

        private:
            class Observer: public webrtc::SetSessionDescriptionObserver {
            public:
                Observer(SessionStateMachine* machine)
                    : machine_(machine)
                {
                }

                void OnSuccess() override;

                void OnFailure(webrtc::RTCError error) override;

                void enter() {
                    inState_ = true;
                }

                void exit() {
                    inState_ = false;
                }

            private:
                SessionStateMachine* machine_;

                bool inState_;
            };

        private:
            const std::string offer_;

            ::rtc::scoped_refptr<Observer> observer_;
        };

    } // namespace rtc
} // namespace messenger
