#include "user_media_acquiring_state.h"

#include "ready_for_negotiation_state.h"

#include <memory>

using namespace messenger::rtc;

const std::string SessionStateMachine::UserMediaAcquiringState::NAME =
    "UserMediaAcquiringState";

SessionStateMachine::UserMediaAcquiringState::UserMediaAcquiringState(
    SessionStateMachine* machine)
    : SessionState(machine)
{
}

void SessionStateMachine::UserMediaAcquiringState::enter() {
    if (!addTracks()) {
        // TODO: SessionDisposedState
        throw std::runtime_error("Can't add audio track");
    }

    machine_->mediator_->updateMediaState(machine_->sessionUuid_, true, false);

    machine_->setState(std::make_unique<ReadyForNegotiationState>(
        machine_, false));
}

bool SessionStateMachine::UserMediaAcquiringState::addTracks() {
    if (!machine_->peerConnection_->GetSenders().empty()) {
        return true;
    }

    ::rtc::scoped_refptr<webrtc::AudioTrackInterface> audioTrack(
        machine_->peerConnectionFactory_->CreateAudioTrack(
            "audio_label",
            machine_->peerConnectionFactory_->CreateAudioSource(machine_->audio_->getAudioOptions())));

    auto resultOrError =
        machine_->peerConnection_->AddTrack(audioTrack, {"stream_id"});

    if (!resultOrError.ok()) {
        return false;
    }

    return true;
}

void SessionStateMachine::UserMediaAcquiringState::exit() {
}
