#include "waiting_for_candidates_state.h"

#include "candidates_sending_state.h"
#include "complete_sending_state.h"

#include <iostream>
#include <memory>

using namespace messenger::rtc;

const std::string SenderStateMachine::WaitingForCandidatesState::NAME = "WaitingForCandidatesState";

SenderStateMachine::WaitingForCandidatesState::WaitingForCandidatesState(SenderStateMachine* machine)
    : SenderState(machine)
{
}

void SenderStateMachine::WaitingForCandidatesState::enter() {
    if (!machine_->unsentCandidates_.empty()) {
        machine_->setState(std::make_unique<CandidatesSendingState>(machine_));

    } else if (machine_->gatheringCompleted_) {
        machine_->setState(std::make_unique<CompleteSendingState>(machine_));
    }
}

void SenderStateMachine::WaitingForCandidatesState::exit() {
}
