#include "waiting_for_connection_state.h"

#include "peer_connection_established_state.h"

#include <memory>

using namespace messenger::rtc;

const std::string SessionStateMachine::WaitingForConnectionState::NAME =
    "WaitingForConnectionState";

SessionStateMachine::WaitingForConnectionState::WaitingForConnectionState(
    SessionStateMachine* machine)
    : NegotiatingState(machine)
    , inState_(std::make_shared<bool>(false))
{
}

void SessionStateMachine::WaitingForConnectionState::enter() {
    NegotiatingState::enter();

    *inState_ = true;

    machine_->candidatesSender_->start();

    // may cause exit() called
    handleIceConnectionState(machine_->peerConnection_->ice_connection_state());
}

void SessionStateMachine::WaitingForConnectionState::OnIceConnectionChange(
    webrtc::PeerConnectionInterface::IceConnectionState newState) {
    NegotiatingState::OnIceConnectionChange(newState);

    handleIceConnectionState(newState);
}

void SessionStateMachine::WaitingForConnectionState::handleIceConnectionState(
    webrtc::PeerConnectionInterface::IceConnectionState newState) {
    switch (newState) {
        case webrtc::PeerConnectionInterface::kIceConnectionConnected:
        case webrtc::PeerConnectionInterface::kIceConnectionCompleted: {
            if (*inState_) {
                machine_->setState(
                    std::make_unique<PeerConnectionEstablishedState>(
                        machine_));
            }

            break;
        }

        default:
            break;
    }
}

void SessionStateMachine::WaitingForConnectionState::exit() {
    *inState_ = false;

    NegotiatingState::exit();
}
