#pragma once

#include "negotiating_state.h"

#include <yandex_io/callkit/rtc/media/session_state_machine.h>

namespace messenger {
    namespace rtc {

        class SessionStateMachine::WaitingForConnectionState: public SessionStateMachine::NegotiatingState {
        public:
            explicit WaitingForConnectionState(SessionStateMachine* machine);

            void enter() override;

            void exit() override;

            static const std::string NAME;

            const std::string& name() const override {
                return NAME;
            }

        public:
            void OnIceConnectionChange(webrtc::PeerConnectionInterface::IceConnectionState newState) override;

        private:
            void handleIceConnectionState(webrtc::PeerConnectionInterface::IceConnectionState newState);

            std::shared_ptr<bool> inState_;
        };

    } // namespace rtc
} // namespace messenger
