#include "stats_sender.h"

using namespace messenger::rtc;

StatsSender::StatsSender(const std::string& sessionUuid,
                         std::shared_ptr<MediatorApi> mediator,
                         std::shared_ptr<TimerFactory> timerFactory,
                         std::shared_ptr<LoopThread> workerThread,
                         std::chrono::seconds sendInterval)
    : sessionUuid_(sessionUuid)
    , mediator_(mediator)
    , timerFactory_(timerFactory)
    , workerThread_(std::move(workerThread))
    , sendingInterval_(sendInterval)
{
    Y_VERIFY(workerThread_->checkInside());
}

StatsSender::~StatsSender() {
    stop();
}

void StatsSender::start() {
    Y_VERIFY(workerThread_->checkInside());

    stop();
    scheduleGatheringAndSending();
}

void StatsSender::stop() {
    Y_VERIFY(workerThread_->checkInside());

    if (timer_) {
        timer_->cancel();
    }
}

void StatsSender::sendImmediately() {
    Y_VERIFY(workerThread_->checkInside());

    sendStats();
}

void StatsSender::scheduleGatheringAndSending() {
    Y_VERIFY(workerThread_->checkInside());

    timer_ = timerFactory_->createTimer(sendingInterval_, [this]() {
        scheduleGatheringAndSending();

        sendStats();
    });
}

void StatsSender::sendStats() {
    Y_VERIFY(workerThread_->checkInside());

    // TODO: get stats
    Json::Value stats;

    mediator_->keepAlive(sessionUuid_, stats);
}
