#pragma once

#include "api/mediator_api.h"

#include <yandex_io/callkit/rtc/utils/timer.h>
#include <yandex_io/callkit/rtc/utils/timer_factory.h>

#include <yandex_io/callkit/util/loop_thread.h>

namespace messenger {
    namespace rtc {

        class StatsSender {
        public:
            StatsSender(
                const std::string& sessionUuid,
                std::shared_ptr<MediatorApi> mediator,
                std::shared_ptr<TimerFactory> timerFactory,
                std::shared_ptr<LoopThread> workerThread,
                std::chrono::seconds sendInterval);

            ~StatsSender();

            void start();

            void stop();

            void sendImmediately();

        private:
            void scheduleGatheringAndSending();

            void sendStats();

        private:
            const std::string sessionUuid_;
            std::shared_ptr<MediatorApi> mediator_;
            std::shared_ptr<TimerFactory> timerFactory_;
            std::shared_ptr<LoopThread> workerThread_;
            std::chrono::seconds sendingInterval_;

            std::shared_ptr<Timer> timer_;
        };

    } // namespace rtc
} // namespace messenger
