#pragma once

#include <memory>
#include <string>

namespace messenger {
    namespace rtc {

        class Transport {
        public:
            using Message = std::string;

            class Listener {
            public:
                virtual ~Listener() = default;

                virtual void onMessage(const Message& message) = 0;
            };

            Transport();
            virtual ~Transport();

            virtual void send(const Message& message) = 0;
            virtual void setListener(std::weak_ptr<Listener> listener) = 0;
        };

    } // namespace rtc
} // namespace messenger
