#include "network_monitor.h"

using namespace messenger;
using namespace messenger::rtc;

NetworkMonitor::NetworkMonitor(std::shared_ptr<LoopThread> workerThread)
    : workerThread_(std::move(workerThread))
{
    Y_VERIFY(workerThread_->checkInside());
}

NetworkMonitor::~NetworkMonitor() = default;

NetworkMonitor::NetworkSubscription
NetworkMonitor::subscribe(NetworkMonitor::NetworkObserver observer) {
    Y_VERIFY(workerThread_->checkInside());

    return observers_.subscribe(std::move(observer));
}
