#pragma once

#include <yandex_io/callkit/util/loop_thread.h>
#include <yandex_io/callkit/util/observer_list.h>

#include <functional>
#include <memory>

namespace messenger {
    namespace rtc {

        enum class ConnectionType {
            CONNECTION_WIFI,
            CONNECTION_NONE,
        };

        // on: worker thread
        class NetworkMonitor {
        public:
            using NetworkObserver = ObserverList<ConnectionType>::ObserverType;
            using NetworkSubscription =
                ObserverList<ConnectionType>::ScopedSubscription;
            NetworkMonitor(std::shared_ptr<LoopThread> workerThread);
            virtual ~NetworkMonitor();

            [[nodiscard]] NetworkSubscription subscribe(NetworkObserver observer);

        private:
            std::shared_ptr<LoopThread> workerThread_;

            ObserverList<ConnectionType> observers_;
        };

    } // namespace rtc
} // namespace messenger
