#include "timer.h"

using namespace messenger;
using namespace messenger::rtc;

Timer::Timer(std::chrono::milliseconds intervalMillis,
             std::function<void()> task,
             std::shared_ptr<LoopThread> workerThread)
    : cancellableExecutor_(ScopedExecutor::create(workerThread))
{
    cancellableExecutor_.executeDelayed(task, intervalMillis);
}

Timer::~Timer() {
    cancel();
}

void Timer::cancel() {
    cancellableExecutor_.reset();
}
