#pragma once

#include <yandex_io/callkit/util/loop_thread.h>

#include <chrono>
#include <functional>
#include <memory>

namespace messenger {
    namespace rtc {

        // on: worker thread
        class Timer {
        public:
            virtual ~Timer();
            void cancel();

        private:
            friend class TimerFactory;

            Timer(std::chrono::milliseconds intervalMillis, std::function<void()> task,
                  std::shared_ptr<LoopThread> workerThread);

            ScopedExecutor cancellableExecutor_;
        };

    } // namespace rtc
} // namespace messenger
