#include "timer_factory.h"

#include "timer.h"

using namespace messenger;
using namespace messenger::rtc;

TimerFactory::TimerFactory(std::shared_ptr<LoopThread> workerThread)
    : workerThread_(std::move(workerThread))
{
}

TimerFactory::~TimerFactory() = default;

std::shared_ptr<Timer>
TimerFactory::createTimer(std::chrono::milliseconds intervalMillis,
                          std::function<void()> task) {
    return std::shared_ptr<Timer>(
        new Timer(intervalMillis, std::move(task), workerThread_));
}
