#pragma once

#include <yandex_io/callkit/util/loop_thread.h>

#include <chrono>
#include <functional>
#include <memory>

namespace messenger {
    namespace rtc {

        class Timer;

        // on: worker thread
        class TimerFactory {
        public:
            TimerFactory(std::shared_ptr<LoopThread> workerThread);
            virtual ~TimerFactory();
            std::shared_ptr<Timer> createTimer(std::chrono::milliseconds intervalMillis,
                                               std::function<void()> task);

        private:
            std::shared_ptr<LoopThread> workerThread_;
        };

    } // namespace rtc
} // namespace messenger
