#include "session.h"

using namespace messenger;

Session::StateChangedSubscription Session::subscribeStateChanged(StateChangedCallback callback) {
    return stateObserverList_.subscribe(std::move(callback));
}

CallbackSubscription Session::subscribeCallCreationFailed(Callback callback) {
    return callCreationFailedObserverList_.subscribe(std::move(callback));
}

Session::CallAcceptedSubscription Session::subscribeCallAccepted(CallAcceptedCallback callback) {
    return acceptObserverList_.subscribe(std::move(callback));
}

Session::CallDeclinedSubscription Session::subscribeCallDeclined(CallDeclinedCallback callback) {
    return declineObserverList_.subscribe(std::move(callback));
}

Session::CallFailedSubscription Session::subscribeCallFailed(CallFailedCallback callback) {
    return failedObserverList_.subscribe(std::move(callback));
}

Session::CallStartedSubscription Session::subscribeCallStarted(CallStartedCallback callback) {
    return startObserverList_.subscribe(std::move(callback));
}

Session::CallEndedSubscription Session::subscribeCallEnded(CallEndedCallback callback) {
    return endObserverList_.subscribe(std::move(callback));
}

bool Session::State::operator==(const State& other) const {
    return authorized == other.authorized && connected == other.connected && status == other.status && direction == other.direction && callGuid == other.callGuid && userName == other.userName && userAvatar == other.userAvatar && userGuid == other.userGuid && isSelfCall == other.isSelfCall && tokenExpired == other.tokenExpired;
}
