#pragma once

#include "session.h"
#include "session_settings.h"

#include <yandex_io/callkit/calls/call/call.h>
#include <yandex_io/callkit/calls/call/call_holder.h>
#include <yandex_io/callkit/calls/call/notifier.h>
#include <yandex_io/callkit/calls/call/status.h>
#include <yandex_io/callkit/util/loop_thread.h>
#include <yandex_io/callkit/util/weak_utils.h>

#include <yandex_io/libs/device/i_device.h>
#include <yandex_io/libs/ipc/i_ipc_factory.h>

#include <condition_variable>
#include <memory>
#include <string>

namespace messenger {

    class LoopThread;
    class SessionService;
    struct SessionParams;

    // Runs operations on control std::thread handling std::threads communication,
    class SessionImpl: public Session, public std::enable_shared_from_this<SessionImpl> {
        CREATE_FROM_INIT(SessionImpl);

    public:
        void init(const std::shared_ptr<quasar::ipc::IIpcFactory>& ipcFactory, std::shared_ptr<YandexIO::IDevice> device, const SessionParams& params);
        ~SessionImpl();

        // Session state
        Session::State getState() override;

        // Call control
        void startCall(const std::string& userGuid, const std::string& callPayload) override;
        void startCallToOwnDevice(const std::string& deviceId, const std::string& callPayload) override;
        void declineIncomingCall() override;
        void acceptIncomingCall() override;
        void hangupCall() override;
        void sendHeartbeat() override;
        void setAllowUsualCalls(bool allowUsualCalls) override;

    public:
        // For tests
        void waitForIdle();

    private:
        Session::State getStateImpl() const;

        void onCurrentCallChanged(Call* call);

        void onCallStatusChanged(Call* call);

        void onTokenExpired();

    private:
        std::shared_ptr<LoopThread> workerThread_;
        // on: worker std::thread
        std::shared_ptr<SessionService> sessionService_;
        std::string sessionId_;

        std::mutex idleMutex_;
        std::condition_variable idleCondition_;
        std::atomic<bool> idleCheck_{false};

        // Call state subscriptions
        Notifier::OnStatusChangeSubscription callStateSubscription_;
        Notifier::OnAcceptSubscription callAcceptSubscription_;
        Notifier::OnDeclineSubscription callDeclineSubscription_;
        Notifier::OnFailureSubscription callFailureSubscription_;
        Notifier::OnStartSubscription callStartSubscription_;
        Notifier::OnEndSubscription callEndSubscription_;

        // Call creation subscriptions
        CallHolder::CallSubscription callChangedSubscription_;
        CallHolder::CallCreationFailedSubscription callCreationFailedSubscription_;
    };

} // namespace messenger
