#pragma once

#include <yandex_io/callkit/util/observer_list.h>
#include <yandex_io/callkit/util/weak_utils.h>

#include <yandex_io/libs/device/i_device.h>
#include <yandex_io/libs/ipc/i_ipc_factory.h>
#include <yandex_io/libs/threading/steady_condition_variable.h>

#include <chrono>
#include <memory>
#include <mutex>
#include <string>

namespace messenger {

    class Session;
    struct PlatformInfoProvider;

    // Runs operations on control std::thread handling std::threads communication,
    //
    // on: any thread
    class SessionProvider {
    public:
        SessionProvider(
            std::shared_ptr<quasar::ipc::IIpcFactory> ipcFactory,
            std::shared_ptr<YandexIO::IDevice> device,
            const std::string& appId,
            const std::string& appName,
            const std::string& appVersion,
            const std::string& passportUid,
            const std::string& authToken,
            const std::vector<std::string>& xivaSubscriptions);

        // "passportUid": "<yandex uid>",
        // "token": "<yandex OAuth token>",
        // "server": "alpha", // 'alpha', 'production' or 'custom'
        // "useDedicatedXiva": false // use a dedicated socket instead of pushd
        // "xivaServiceName": "", // optional, used when server=custom
        // "messengerApiHost": "", // optional, used when server=custom
        std::shared_ptr<Session> createCustomSession(
            const std::string& passportUid,
            const std::string& token,
            const std::string& server,
            bool useDedicatedXiva,
            const std::string& xivaServiceName,
            const std::string& messengerApiHost,
            const std::vector<std::string>& xivaSubscriptions = {});

        // Creates Session with Xiva over Pushd service with given auth params.
        std::shared_ptr<Session> createQuasarPushdSession(
            const std::string& passportUid,
            const std::string& authToken);

        // Creates Session with Xiva over Pushd service:
        // - with last known yandex token from device;
        // - ENV settings form 'pushd' config (pushd/xivaServices must include
        //   one of messenger services).
        // If no token, nullptr returned;
        std::shared_ptr<Session> createQuasarPushdSession();

        // Creates Session with Xiva over dedicated in-process socket:
        // - with last known yandex token from device;
        // - ENV settings must be passed here - 'alpha', 'production' of 'config'.
        //   for 'config' - see createQuasarPushdSession() description.
        // If no token, nullptr returned;
        std::shared_ptr<Session> createQuasarDedicatedSession(const std::string& env);

    public:
        static std::vector<std::string> getXivaServices(const std::shared_ptr<quasar::ipc::IIpcFactory>& ipcFactory);

    private:
        const std::shared_ptr<quasar::ipc::IIpcFactory> ipcFactory_;
        const std::shared_ptr<YandexIO::IDevice> device_;
        std::mutex mutex_;
        quasar::SteadyConditionVariable wakeupVar_;
        std::string configEnv_;

        const std::string passportUid_;
        const std::string authToken_;
        const std::vector<std::string> xivaSubscriptions_;

        std::shared_ptr<PlatformInfoProvider> info_;
    };

} // namespace messenger
