#pragma once

#include "session_settings.h"

#include <yandex_io/callkit/api/session_request_factory.h>
#include <yandex_io/callkit/calls/call/status.h>
#include <yandex_io/callkit/util/weak_utils.h>

#include <yandex_io/libs/device/i_device.h>
#include <yandex_io/libs/ipc/i_ipc_factory.h>

#include <functional>
#include <memory>

namespace messenger {

    class CallHolder;
    class CallingService;
    class ConnectionService;
    class DataStorage;
    class LoopThread;
    class SessionApiService;

    // on: worker
    class SessionService: public std::enable_shared_from_this<SessionService> {
        CREATE_FROM_INIT(SessionService);

    public:
        void init(const std::shared_ptr<quasar::ipc::IIpcFactory>& ipcFactory,
                  SessionRequestFactory::OnExpiredTokenCallback callback,
                  const SessionParams& params,
                  std::shared_ptr<LoopThread> workerThread,
                  std::shared_ptr<YandexIO::IDevice> device);

        virtual ~SessionService();

        void init();

        bool isAuthorized();
        bool isConnected();
        bool isTokenExpired() const;
        std::string getOwnGuid();

        bool hasBgTasks();
        void runOnBgIdle(std::function<void()> callback);

        void setAllowUsualCalls(bool allowUsualCalls);
        void sendHeartbeat();
        std::shared_ptr<CallHolder> getCallHolder();
        void startCall(const std::string& userGuid, const std::string& callPayload);
        void startCallToOwnDevice(const std::string& deviceId, const std::string& callPayload);
        void declineIncomingCall();
        void acceptIncomingCall();
        void hangupCall();

    private:
        std::unique_ptr<SessionSettings> settings_;
        bool tokenExpired_ = false;

        std::shared_ptr<LoopThread> workerThread_;
        std::shared_ptr<DataStorage> dataStorage_;
        std::shared_ptr<SessionApiService> apiService_;
        std::shared_ptr<ConnectionService> connectionService_;
        std::shared_ptr<CallingService> callingService_;
    };

} // namespace messenger
