#include "session_settings.h"

#include <yandex_io/libs/base/utils.h>
#include <yandex_io/libs/cryptography/digest.h>

#include <util/system/yassert.h>

using namespace messenger;

SessionParams::SessionParams(const std::string& passportUid,
                             const std::string& token,
                             const std::string& envStr, bool useDedicatedXiva,
                             const std::string& xivaServiceName,
                             const std::string& messengerApiHost,
                             const std::vector<std::string>& xivaSubscriptions)
    : messengerApiHost(messengerApiHost)
    , xivaServiceName(xivaServiceName)
    , passportUid(passportUid)
    , token(token)
    , useDedicatedXiva(useDedicatedXiva)
    , xivaSubscriptions(xivaSubscriptions)
{
    if (envStr == "custom") {
        server = CUSTOM;
    } else if (envStr == "production" || envStr.empty()) {
        server = PRODUCTION;
    } else {
        server = ALPHA;
    }
}

SessionSettings::SessionSettings(const SessionParams& inParams)
    : params(inParams)
{
    Y_VERIFY(inParams.platformInfo);
    switch (params.server) {
        case SessionParams::ALPHA:
            params.xivaServiceName = "messenger";
            params.messengerApiHost = "api.messenger.alpha.yandex.net";
            break;
        case SessionParams::PRODUCTION:
            params.xivaServiceName = "messenger-prod";
            params.messengerApiHost = "api.messenger.yandex.net";
            break;
        case SessionParams::CUSTOM:
            Y_VERIFY(!params.messengerApiHost.empty());
            Y_VERIFY(!params.xivaServiceName.empty());
            break;
        default:
            Y_VERIFY(!"Not implemented here");
            break;
    }
    sessionId = quasar::makeUUID();
    storageId = quasar::calcSHA1Digest(params.token + params.messengerApiHost);
}
