#pragma once

#include <memory>
#include <string>
#include <vector>

namespace messenger {

    // Kind of input params.
    struct PlatformInfo {
        std::string appId;
        std::string appName;
        std::string appVersion;
        std::string osVersion;
        std::string deviceManufacturer;
        std::string deviceType;
        std::string deviceId;
        std::string deviceOs;
        std::string softwareVersion;
    };

    // This provider was required for 'DeviceGroup' property that can be changed
    // in runtime.
    // on: worker thread
    struct PlatformInfoProvider {
        virtual ~PlatformInfoProvider() = default;
        virtual PlatformInfo create() = 0;
    };

    struct SessionParams {
        SessionParams(const std::string& passportUid, const std::string& token,
                      const std::string& envStr, bool useDedicatedXiva,
                      const std::string& xivaServiceName,
                      const std::string& messengerApiHost, // for debug
                      const std::vector<std::string>& xivaSubscriptions);
        SessionParams() = default;

        enum Server {
            ALPHA,
            PRODUCTION,
            CUSTOM,
        };

        Server server = PRODUCTION;
        std::string messengerApiHost;
        std::string xivaServiceName;

        std::string passportUid;
        std::string token;
        bool useDedicatedXiva = false;

        // On quasar, platform configuration can change in runtime.
        // These properties are taken on demand (just before a call)
        std::shared_ptr<PlatformInfoProvider> platformInfo;

        std::vector<std::string> xivaSubscriptions;
    };

    struct XivaSettings {
        std::string sign;
        std::string ts;
    };

    struct SessionSettings {
        SessionSettings(const SessionParams& inParams);
        SessionParams params;
        XivaSettings xivaSettings;
        std::string sessionId;
        std::string storageId;
    };

} // namespace messenger
