#pragma once

#include <yandex_io/callkit/util/observer_list.h>

#include <json/value.h>

#include <memory>

namespace messenger {

    class LoopThread;

    // on: worker
    class DataStorage {
    public:
        DataStorage(const std::string& storageId,
                    std::shared_ptr<LoopThread> workerThread);
        virtual ~DataStorage();

        Json::Value tryGetUser();
        void setUser(const Json::Value& value);

        Json::Value tryGetXivaSecret();
        void setXivaSecret(const Json::Value& value);

        [[nodiscard]] CallbackSubscription subscribeUserData(Callback callback);

    private:
        Json::Value tryGetPersistentValue(const char* key);
        void setPersistentValue(const char* key, const Json::Value& value);
        Json::Value tryGetSessionValue(const char* key);
        void setSessionValue(const char* key, const Json::Value& value);
        void shouldSave();
        void save();

        std::string filePath_;
        Json::Value persistentData_;
        Json::Value sessionData_;
        std::shared_ptr<LoopThread> workerThread_;

        CallbackObserverList userDataObservers_;
    };

} // namespace messenger
