#pragma once

#include "async_task.h"
#include "loop_thread.h"

#include <functional>
#include <memory>
#include <queue>
#include <vector>

namespace messenger {

    // on: worker
    class AsyncService {
    public:
        explicit AsyncService(std::shared_ptr<LoopThread> workerThread);
        virtual ~AsyncService();

        void start(std::shared_ptr<AsyncTask> task);
        void cancel(std::shared_ptr<AsyncTask> task);

        bool hasTasks() const;
        void runOnIdle(std::function<void()> callback);

    private:
        void tryExecuteNext();
        void processIdleState();
        // on: bg
        static void executeInBg(std::weak_ptr<LoopThread> workerThread,
                                std::shared_ptr<AsyncTask> task,
                                std::function<void()> callback);
        void onExecuted(std::shared_ptr<AsyncTask> task);

        std::shared_ptr<LoopThread> workerThread_;
        std::queue<std::shared_ptr<AsyncTask>> pendingTasks_;
        std::vector<std::shared_ptr<AsyncTask>> activeTasks_;
        std::queue<std::function<void()>> idleCallbacks_;
    };

} // namespace messenger
