#pragma once

#include <atomic>
#include <string>

namespace messenger {

    class AsyncTask {
    public:
        AsyncTask();
        virtual ~AsyncTask();
        // on: bg
        virtual void run() = 0;
        bool isCancelled();
        virtual std::string getName() = 0;

    protected:
        void setCancelled();

    private:
        friend class AsyncService;

        virtual void onFinished() = 0;

        std::atomic<bool> cancelled_;
    };

} // namespace messenger
