#include "cancelable.h"

using namespace messenger;

Cancelable::Cancelable(std::function<void()> onCancel)
    : onCancel_(std::move(onCancel))
{
}

Cancelable::Cancelable() = default;

Cancelable::~Cancelable() = default;

void Cancelable::cancel() {
    if (onCancel_) {
        onCancel_();
    }
    onCancel_ = nullptr;
}
