#pragma once

#include <functional>
#include <memory>

// not thread-safe
class CancellableCallback {
public:
    CancellableCallback() {
    }

    CancellableCallback(std::function<void()> callback)
        : sharedCallback_(new Callback(std::move(callback)))
    {
    }

    CancellableCallback(const CancellableCallback& other)
        : sharedCallback_(other.sharedCallback_)
    {
    }

    virtual ~CancellableCallback() = default;

    void run() const {
        if (sharedCallback_ && sharedCallback_->func) {
            sharedCallback_->func();
        }
    }

    void cancel() {
        if (sharedCallback_) {
            sharedCallback_->func = nullptr;
        }
    }

private:
    struct Callback {
        Callback(std::function<void()> func)
            : func(std::move(func))
        {
        }
        std::function<void()> func;
    };
    std::shared_ptr<Callback> sharedCallback_;
};
