#include "murmur_hash2.h"

using namespace messenger;

namespace {
    uint64_t murmurHash2Impl(const char* data, uint32_t length, uint64_t seed) {
        // Helps convert a byte into its unsigned value
        const uint32_t UNSIGNED_MASK = 0xFF;
        // Helps convert integer to its unsigned value
        const uint64_t UINT_MASK = 0xFFFFFFFFl;

        const uint64_t m = 0x5bd1e995l;
        const uint32_t r = 24;
        // Initialize the hash to a 'random' value
        uint64_t hash = ((seed ^ length) & UINT_MASK);
        // Mix 4 bytes at a time into the hash
        uint32_t length4 = length >> 2;
        for (uint32_t i = 0; i < length4; i++) {
            uint32_t i4 = i << 2;

            uint64_t k = (data[i4] & UNSIGNED_MASK);
            k |= (data[i4 + 1] & UNSIGNED_MASK) << 8;
            k |= (data[i4 + 2] & UNSIGNED_MASK) << 16;
            k |= (data[i4 + 3] & UNSIGNED_MASK) << 24;

            k = ((k * m) & UINT_MASK);
            k ^= ((k >> r) & UINT_MASK);
            k = ((k * m) & UINT_MASK);

            hash = ((hash * m) & UINT_MASK);
            hash = ((hash ^ k) & UINT_MASK);
        }
        // Handle the last few bytes of the input array
        uint32_t offset = length4 << 2;
        switch (length & 3) {
            case 3:
                hash ^= (data[offset + 2] & UNSIGNED_MASK) << 16;
            case 2:
                hash ^= (data[offset + 1] & UNSIGNED_MASK) << 8;
            case 1:
                hash ^= data[offset] & UNSIGNED_MASK;
                hash = ((hash * m) & UINT_MASK);
        }
        hash ^= ((hash >> 13) & UINT_MASK);
        hash = ((hash * m) & UINT_MASK);
        hash ^= hash >> 15;

        return hash;
    }
} // namespace

uint32_t messenger::murmurHash2(const std::string& data) {
    return murmurHash2Impl(data.data(), data.size(), 0u);
}
