#pragma once

#include <memory>
#include <string>

namespace messenger {
    namespace xiva {

        class Request {
        public:
            virtual ~Request() = default;
            [[nodiscard]] virtual std::string getPath() const = 0;
            [[nodiscard]] virtual std::string getPayload() const = 0;
            virtual void onFail() = 0;
            virtual void onDataFrame(const std::string& payload) = 0;
            virtual void onProxyStatus(uint16_t errorCode,
                                       const std::string& errorName) = 0;
            virtual void onTimeout() = 0;
            virtual void onCancel() = 0;
        };

    } // namespace xiva
} // namespace messenger
