#include "socket_api.h"

#include <yandex_io/libs/logging/logging.h>

using namespace messenger::xiva;

SocketApi::SocketApi() {
    // To avoid additional synchronization, ObserverList is used.
    selfStatusSubscription_ = statusObservers_.subscribe(
        [this](Status status) { currentStatus_ = status; });
}

SocketApi::Status SocketApi::getStatus() {
    return currentStatus_;
}

SocketApi::DataSubscription
SocketApi::subscribeBinaryData(xiva::SocketApi::DataObserver observer) {
    return binaryObservers_.subscribe(std::move(observer));
}

SocketApi::DataSubscription
SocketApi::subscribeTextData(xiva::SocketApi::DataObserver observer) {
    return textObservers_.subscribe(std::move(observer));
}

SocketApi::StatusSubscription
SocketApi::subscribe(xiva::SocketApi::StatusObserver observer) {
    return statusObservers_.subscribe(std::move(observer));
}

void SocketApi::handleBinaryData(const std::string& data) {
    binaryObservers_.notifyObservers(data);
}

void SocketApi::handleTextData(const std::string& text) {
    textObservers_.notifyObservers(text);
}

void SocketApi::handleStatus(Status status) {
    statusObservers_.notifyObservers(status);
}
