#include "alarm_capability_proxy.h"

#include <yandex_io/libs/logging/logging.h>
#include <yandex_io/protos/quasar_proto.pb.h>

namespace YandexIO {

    AlarmCapabilityProxy::AlarmCapabilityProxy(std::weak_ptr<IRemotingRegistry> remotingRegistry,
                                               std::shared_ptr<quasar::ICallbackQueue> worker)
        : IRemoteObject(std::move(remotingRegistry))
        , callbackQueue_(std::move(worker))
        , remoteObjectId_("AlarmCapability")
    {
    }

    AlarmCapabilityProxy::~AlarmCapabilityProxy()
    {
        if (auto remotingRegistry = getRemotingRegistry().lock()) {
            remotingRegistry->removeRemoteObject(remoteObjectId_);
        }
    }

    void AlarmCapabilityProxy::init()
    {
        if (auto remotingRegistry = getRemotingRegistry().lock()) {
            remotingRegistry->addRemoteObject(remoteObjectId_, weak_from_this());
        }
    }

    void AlarmCapabilityProxy::handleRemotingMessage(const quasar::proto::Remoting& /*message*/,
                                                     std::shared_ptr<IRemotingConnection> /*connection*/) {
        // todo: implement with listeners
    }

    void AlarmCapabilityProxy::handleRemotingConnect(std::shared_ptr<IRemotingConnection> connection) {
        callbackQueue_->add([this, connection]() {
            YIO_LOG_INFO("Connected to " << remoteObjectId_);
            connection_ = connection;
        });
    }

    void AlarmCapabilityProxy::stopAlarm() {
        callbackQueue_->add([this]() {
            quasar::proto::Remoting remoting;
            remoting.set_remote_object_id(TString(remoteObjectId_));

            auto method = remoting.mutable_alarm_capability_method();
            method->set_method(quasar::proto::Remoting::AlarmCapabilityMethod::STOP_ALARM);

            trySendMessage(remoting);
        });
    }

    void AlarmCapabilityProxy::addListener(std::weak_ptr<IAlarmCapabilityListener> /*listener*/) {
        // todo: implement
    }

    void AlarmCapabilityProxy::removeListener(std::weak_ptr<IAlarmCapabilityListener> /*listener*/) {
        // todo: implement
    }

    void AlarmCapabilityProxy::trySendMessage(const quasar::proto::Remoting& message) {
        if (!connection_) {
            YIO_LOG_WARN("Not connected to " << remoteObjectId_);
            return;
        }
        connection_->sendMessage(message);
    }

} // namespace YandexIO
