#pragma once

#include <yandex_io/capabilities/alarm/interfaces/i_alarm_capability.h>

#include <yandex_io/libs/threading/i_callback_queue.h>

#include <yandex_io/sdk/private/remoting/i_remote_object.h>
#include <yandex_io/sdk/private/remoting/i_remoting_registry.h>

namespace YandexIO {

    class AlarmCapabilityProxy: public IAlarmCapability,
                                public YandexIO::IRemoteObject,
                                public std::enable_shared_from_this<AlarmCapabilityProxy> {
    public:
        explicit AlarmCapabilityProxy(std::weak_ptr<IRemotingRegistry> remotingRegistry,
                                      std::shared_ptr<quasar::ICallbackQueue> worker);
        ~AlarmCapabilityProxy();

        void init();

        /// IAlarmCapability implementation
        void addListener(std::weak_ptr<IAlarmCapabilityListener> listener) override;
        void removeListener(std::weak_ptr<IAlarmCapabilityListener> listener) override;

        void stopAlarm() override;

        /// IRemoteObject implementation
        void handleRemotingMessage(const quasar::proto::Remoting& message,
                                   std::shared_ptr<IRemotingConnection> connection) override;
        void handleRemotingConnect(std::shared_ptr<IRemotingConnection> connection) override;

    private:
        void trySendMessage(const quasar::proto::Remoting& message);

    private:
        const std::shared_ptr<quasar::ICallbackQueue> callbackQueue_;
        const std::string remoteObjectId_;
        std::shared_ptr<IRemotingConnection> connection_;
    };

} // namespace YandexIO
