#pragma once

#include "interfaces/i_alice_capability.h"

#include <yandex_io/libs/json_utils/json_utils.h>
#include <yandex_io/libs/threading/i_callback_queue.h>

#include <yandex_io/sdk/private/remoting/i_remote_object.h>
#include <yandex_io/sdk/private/remoting/i_remoting_registry.h>

#include <memory>
#include <set>
#include <string>
#include <unordered_map>

namespace YandexIO {

    class AliceCapabilityProxy: public IAliceCapability,
                                public YandexIO::IRemoteObject,
                                public std::enable_shared_from_this<AliceCapabilityProxy> {
    public:
        AliceCapabilityProxy(std::weak_ptr<IRemotingRegistry> remotingRegistry,
                             std::shared_ptr<quasar::ICallbackQueue> worker);
        ~AliceCapabilityProxy();

        void init();

        void startRequest(
            std::shared_ptr<VinsRequest> request,
            std::shared_ptr<IAliceRequestEvents> events) override;
        void cancelDialog() override;
        void cancelDialogAndClearQueue() override;
        void startConversation(const VinsRequest::EventSource& eventSource) override;
        void stopConversation() override;
        void toggleConversation(const VinsRequest::EventSource& eventSource) override;
        void finishConversationVoiceInput() override;

        void addListener(std::weak_ptr<IAliceCapabilityListener> listener) override;
        void removeListener(std::weak_ptr<IAliceCapabilityListener> listener) override;

        /// IRemoteObject implementation
        void handleRemotingMessage(const quasar::proto::Remoting& message,
                                   std::shared_ptr<IRemotingConnection> connection) override;
        void handleRemotingConnect(std::shared_ptr<IRemotingConnection> connection) override;

    private:
        void handleRemotingMessageImpl(const quasar::proto::Remoting& message);

        void trySendMessage(const quasar::proto::Remoting& message);

    private:
        struct Request {
            std::shared_ptr<VinsRequest> request;
            std::shared_ptr<IAliceRequestEvents> events;
        };

    private:
        const std::shared_ptr<quasar::ICallbackQueue> callbackQueue_;
        const std::string remoteObjectId_;
        std::shared_ptr<IRemotingConnection> connection_;

        std::unordered_map<std::string, Request> requestsById_;

        using WeakListenerCompare = std::owner_less<std::weak_ptr<IAliceCapabilityListener>>;
        std::set<std::weak_ptr<IAliceCapabilityListener>, WeakListenerCompare> listeners_;
    };

} // namespace YandexIO
