#include "alice_request_events_proxy.h"

#include <yandex_io/libs/json_utils/json_utils.h>

using namespace YandexIO;

AliceRequestEventsProxy::AliceRequestEventsProxy(
    std::string requestId, std::shared_ptr<IRemotingConnection> connection)
    : requestId_(std::move(requestId))
    , connection_(std::move(connection))
    , remoteObjectId_("AliceCapability")
{
}

AliceRequestEventsProxy::~AliceRequestEventsProxy()
{
}

void AliceRequestEventsProxy::onAliceRequestStarted(std::shared_ptr<VinsRequest> request)
{
    Y_UNUSED(request);

    quasar::proto::Remoting remoting;
    remoting.set_remote_object_id(TString(remoteObjectId_));
    auto method = remoting.mutable_alice_request_events_method();
    method->set_request_id(TString(requestId_));
    method->set_method(quasar::proto::Remoting::AliceRequestEventsMethod::ALICE_REQUEST_STARTED);

    connection_->sendMessage(remoting);
}

void AliceRequestEventsProxy::onAliceRequestCompleted(
    std::shared_ptr<VinsRequest> request, const Json::Value& response)
{
    Y_UNUSED(request);

    quasar::proto::Remoting remoting;
    remoting.set_remote_object_id(TString(remoteObjectId_));
    auto method = remoting.mutable_alice_request_events_method();
    method->set_request_id(TString(requestId_));
    method->set_method(quasar::proto::Remoting::AliceRequestEventsMethod::ALICE_REQUEST_COMPLETED);
    method->set_vins_response_json(quasar::jsonToString(response));

    connection_->sendMessage(remoting);
}

void AliceRequestEventsProxy::onAliceRequestError(
    std::shared_ptr<VinsRequest> request, const std::string& errorCode, const std::string& errorText)
{
    Y_UNUSED(request);

    quasar::proto::Remoting remoting;
    remoting.set_remote_object_id(TString(remoteObjectId_));
    auto method = remoting.mutable_alice_request_events_method();
    method->set_request_id(TString(requestId_));
    method->set_method(quasar::proto::Remoting::AliceRequestEventsMethod::ALICE_REQUEST_ERROR);
    method->set_error_code(TString(errorCode));
    method->set_error_text(TString(errorText));

    connection_->sendMessage(remoting);
}
