#pragma once

#include "interfaces/i_alice_capability.h"

#include <yandex_io/sdk/private/remoting/i_remoting_connection.h>

#include <memory>
#include <string>

namespace YandexIO {

    class AliceRequestEventsProxy: public IAliceRequestEvents {
    public:
        AliceRequestEventsProxy(
            std::string requestId,
            std::shared_ptr<IRemotingConnection> connection);
        ~AliceRequestEventsProxy();

        void onAliceRequestStarted(std::shared_ptr<VinsRequest> request) override;
        void onAliceRequestCompleted(std::shared_ptr<VinsRequest> request, const Json::Value& response) override;
        void onAliceRequestError(std::shared_ptr<VinsRequest> request, const std::string& errorCode, const std::string& errorText) override;

    private:
        static quasar::proto::VinsRequest convertRequestToProtobuf(const std::shared_ptr<VinsRequest>& request);

    private:
        const std::string requestId_;
        const std::shared_ptr<IRemotingConnection> connection_;
        const std::string remoteObjectId_;
    };

} // namespace YandexIO
