#include "i_alice_capability.h"

#include <yandex_io/libs/base/directives.h>
#include <yandex_io/sdk/interfaces/directive.h>

namespace YandexIO {

    IAliceRequestEvents::~IAliceRequestEvents() = default;

    IAliceCapability::~IAliceCapability() = default;

    void IAliceCapability::startVoiceInput(
        const VinsRequest::EventSource& eventSource,
        std::shared_ptr<IAliceRequestEvents> events)
    {
        auto request = VinsRequest::createListenRequest(Directive::Data(quasar::Directives::LISTEN, "local_action"), eventSource);

        startRequest(request, events);
    }

} // namespace YandexIO
