#pragma once

#include "i_alice_capability_listener.h"
#include "vins_request.h"

#include <alice/megamind/protos/speechkit/request.pb.h>

#include <memory>

namespace YandexIO {

    class IAliceRequestEvents {
    public:
        virtual ~IAliceRequestEvents();

        virtual void onAliceRequestStarted(std::shared_ptr<VinsRequest> request) = 0;
        virtual void onAliceRequestCompleted(std::shared_ptr<VinsRequest> request, const Json::Value& response) = 0;
        virtual void onAliceRequestError(std::shared_ptr<VinsRequest> request, const std::string& errorCode, const std::string& errorText) = 0;
    };

    class IAliceCapability {
    public:
        virtual ~IAliceCapability();

        void startVoiceInput(
            const VinsRequest::EventSource& eventSource,
            std::shared_ptr<IAliceRequestEvents> events = nullptr);

        virtual void startRequest(
            std::shared_ptr<VinsRequest> request,
            std::shared_ptr<IAliceRequestEvents> events) = 0;
        virtual void cancelDialog() = 0;
        virtual void cancelDialogAndClearQueue() = 0;
        virtual void startConversation(const VinsRequest::EventSource& eventSource) = 0;
        virtual void stopConversation() = 0;
        virtual void toggleConversation(const VinsRequest::EventSource& eventSource) = 0;
        virtual void finishConversationVoiceInput() = 0;

        virtual void addListener(std::weak_ptr<IAliceCapabilityListener> listener) = 0;
        virtual void removeListener(std::weak_ptr<IAliceCapabilityListener> listener) = 0;
    };

} // namespace YandexIO
