#pragma once

#include <yandex_io/capabilities/alice/interfaces/i_alice_capability.h>

#include <library/cpp/testing/gmock_in_unittest/gmock.h>

namespace YandexIO {

    class MockIAliceCapability: public IAliceCapability {
    public:
        MOCK_METHOD(void, startRequest, (std::shared_ptr<VinsRequest>, std::shared_ptr<IAliceRequestEvents>), (override));
        MOCK_METHOD(void, cancelDialog, (), (override));
        MOCK_METHOD(void, cancelDialogAndClearQueue, (), (override));
        MOCK_METHOD(void, startConversation, (const VinsRequest::EventSource&), (override));
        MOCK_METHOD(void, stopConversation, (), (override));
        MOCK_METHOD(void, toggleConversation, (const VinsRequest::EventSource&), (override));
        MOCK_METHOD(void, finishConversationVoiceInput, (), (override));

        MOCK_METHOD(void, addListener, (std::weak_ptr<IAliceCapabilityListener>), (override));
        MOCK_METHOD(void, removeListener, (std::weak_ptr<IAliceCapabilityListener>), (override));
    };

} // namespace YandexIO
