#pragma once

#include <alice/megamind/protos/speechkit/request.pb.h>
#include <yandex_io/libs/base/utils.h>
#include <yandex_io/sdk/interfaces/directive.h>
#include <yandex_io/protos/model_objects.pb.h>

#include <json/json.h>

#include <memory>
#include <string>

namespace YandexIO {

    class VinsRequest {
    public:
        using EventSource = NAlice::TSpeechKitRequestProto_TEventSource;

        VinsRequest(Json::Value event, EventSource eventSource, std::optional<std::string> requestId = std::nullopt);

        const std::string& getId() const;
        bool isServerAction() const;
        bool isUserInitiatedAction() const;
        bool isVoiceInput() const;
        bool isVoiceprintMatch() const;

        void setIgnoreAnswer(bool value);
        bool getIgnoreAnswer() const;

        void setIsParallel(bool value);
        bool getIsParallel() const;

        void setIsReminder(bool value);
        bool getIsReminder() const;

        void setAsrText(const std::string& value);
        const std::string& getAsrText() const;

        const Json::Value& getEvent() const;
        const EventSource& getEventSource() const;
        std::string getActivationType() const;

        void setIsPrefetch(bool isPrefetch);
        bool isPrefetch() const;

        bool getIsSilent() const;
        void setIsSilent(bool silent);

        bool isIgnoreCriticalUpdate() const;
        void setIsIgnoreCriticalUpdate(bool value);

        bool getResetSession() const;
        void setResetSession(bool value);

        const std::string& getMessageId() const;
        void setMessageId(const std::string& value);

        const std::string& getParentMessageId() const;
        void setParentMessageId(const std::string& value);

        bool getVoiceSession() const;
        void setVoiceSession(bool value);

        bool isGetNext() const;
        void setIsGetNext(bool value);

        std::string toString() const;

        bool eteShouldBindToPrevRequest() const;
        void setEteShouldBindToPrevRequest(bool value);

        std::optional<std::chrono::milliseconds> getStartingSilenceTimeout() const;
        void setStartingSilenceTimeout(std::chrono::milliseconds value);

        bool getIsEnqueued() const;
        void setEnqueued(bool value);

        void setGuestOptions(NAlice::TGuestOptions value);
        const NAlice::TGuestOptions& getGuestOptions() const;

    public:
        static std::shared_ptr<VinsRequest> createServerActionRequest(const Directive::Data& data);
        static std::shared_ptr<VinsRequest> createEventRequest(const Json::Value& event, EventSource eventSource, std::optional<std::string> requestId = std::nullopt);
        static std::shared_ptr<VinsRequest> createListenRequest(const Directive::Data& data, const EventSource& eventSource, std::optional<std::string> requestId = std::nullopt);

        static EventSource createHardwareButtonClickEventSource(const std::string& id = quasar::makeUUID());
        static EventSource createSoftwareAutoDirectiveEventSource(const std::string& id = quasar::makeUUID());
        static EventSource createSoftwareDirectiveEventSource(const std::string& id = quasar::makeUUID());
        static EventSource createSoftwareSpotterEventSource(const std::string& id = quasar::makeUUID());
        static EventSource createVoiceprintMatchEventSource(const std::string& id = quasar::makeUUID());

        static Json::Value buildReminderEvent(const std::string& reminder);
        static Json::Value buildTextActionEvent(const std::string& textAction);
        static Json::Value buildNewDialogSessionEvent(const std::string& dialogId);
        static Json::Value buildTextInputEvent(const std::string& text);
        static Json::Value buildNextTrackSemanticFrame(bool setPause);
        static Json::Value buildPrevTrackSemanticFrame(bool setPause);
        static Json::Value buildStartMusicSemanticFrame();
        static Json::Value buildPlayerContinueSemanticFrame();
        static Json::Value buildGuestEnrollmentStartSemanticFrame(const std::string& puid);
        static Json::Value buildEnrollmentStatusSemanticFrame(const std::string& puid, bool success, const std::string& failureReason, const std::string& details);
        static Json::Value buildGuestEnrollmentFinishSemanticFrame();
        static Json::Value buildEqualizerSettingsRequest();

        static quasar::proto::VinsRequest convertToVinsRequestProtobuf(const std::shared_ptr<VinsRequest>& request);
        static std::shared_ptr<VinsRequest> createVinsRequestFromProtobuf(const quasar::proto::VinsRequest& protobuf);

    private:
        const std::string id_;
        std::string messageId_;
        std::string parentMessageId_;
        Json::Value event_;
        EventSource eventSource_;
        bool ignoreAnswer_ = false;
        bool isReminder_ = false;
        std::string asrText_;
        bool isPrefetch_ = false;
        bool isSilent_ = true;
        bool isIgnoreCriticalUpdate_ = false;
        bool resetSession_ = false;
        bool voiceSession_ = true;
        bool isGetNext_ = false;
        bool eteShouldBindToPrevRequest_ = false;
        std::optional<std::chrono::milliseconds> startingSilenceTimeout_;
        bool isParallel_ = false;
        bool isEnqueued_ = false;
        NAlice::TGuestOptions guestOptions_;
    };

} // namespace YandexIO
