#pragma once

#include <yandex_io/protos/model_objects.pb.h>
#include <alice/megamind/protos/common/device_state.pb.h>
#include <yandex_io/capabilities/device_state/interfaces/i_device_state_capability.h>

namespace YandexIO {

    NAlice::TDeviceState::TRcuState convertRcuState(const quasar::proto::RcuState& state);
    NAlice::TDeviceState::TScreen convertScreenState(const quasar::proto::AppState::MediaInfo& state);
    NAlice::TDeviceState::TPackagesState convertPackagesState(const quasar::proto::PackagesState& state);
    NAlice::TDeviceState::TMusic convertMusicState(const quasar::proto::AppState::MusicState& state, int64_t lastPlayTs = 0);
    google::protobuf::Struct convertRadioState(const quasar::proto::AppState::RadioState& state, int64_t lastPlayTs = 0);
    NAlice::TDeviceState::TAudioPlayer convertAudioPlayerState(const quasar::proto::AudioClientEvent& event);
    NAlice::TDeviceState::TBluetooth convertBluetoothState(const quasar::proto::BluetoothPlayerState& state);
    NAlice::TDeviceState::TVideo convertVideoState(const yandex_io::proto::TVideo& state);
    NAlice::TDeviceState::TVideo convertVideoState(const quasar::proto::VideoState& videoState, const quasar::proto::AppState::ScreenState& screenState, int64_t lastPlayTs = 0, bool isScreenActive = false);
    NAlice::TDeviceState::TMultiroom convertMultiroomState(const quasar::proto::MultiroomState& state);
    NAlice::TDeviceState::TLastWatched convertLastWatched(const quasar::proto::WatchedVideoState& state);
    NAlice::TDeviceState::TTimers convertTimers(const quasar::proto::TimersState& state, const std::optional<quasar::proto::Alarm>& currentlyPlaying);
    NAlice::TDeviceState::TTimers::TTimer convertTimer(const quasar::proto::Alarm& state, bool isPlaying);

    std::unordered_set<TString> convertFeatures(const Json::Value& features);
    NAlice::TExperimentsProto convertExperiments(const Json::Value& arrayExps, const Json::Value& dictExps);

    NAlice::TDeviceState convertAppState(const quasar::proto::AppState& appState);
    void fillFromAppState(const std::shared_ptr<YandexIO::IDeviceStateCapability>& capability, const quasar::proto::AppState& appState);

    quasar::proto::BluetoothPlayerState convertBluetoothState(const NAlice::TDeviceState::TBluetooth& state);
    quasar::proto::RcuState convertRcuState(const NAlice::TDeviceState::TRcuState& state);
    quasar::proto::AppState::MediaInfo convertScreenState(const NAlice::TDeviceState::TScreen& state);
    quasar::proto::PackagesState convertPackagesState(const NAlice::TDeviceState::TPackagesState& state);
    yandex_io::proto::TVideo convertVideoState(const NAlice::TDeviceState::TVideo& state);
    quasar::proto::AppState::RadioState convertRadioState(const google::protobuf::Struct& state);
    quasar::proto::AudioClientEvent convertAudioPlayerState(const NAlice::TDeviceState::TAudioPlayer& state);
    quasar::proto::AppState::ScreenState convertLegacyScreenState(const NAlice::TDeviceState::TVideo& state);
    quasar::proto::VideoState convertLegacyVideoState(const NAlice::TDeviceState::TVideo& state);
    quasar::proto::AppState::MusicState convertMusicState(const NAlice::TDeviceState::TMusic& state);

    quasar::proto::AppState convertAppState(const NAlice::TDeviceState& state);

    quasar::proto::SimplePlayerState convertMusicToSimplePlayerState(const NAlice::TDeviceState::TMusic& music, bool showSimplePlayer);
    quasar::proto::SimplePlayerState convertRadioToSimplePlayerState(const google::protobuf::Struct& radio, bool showSimplePlayer);
    quasar::proto::SimplePlayerState convertAudioPlayerToSimplePlayerState(const NAlice::TDeviceState::TAudioPlayer& audioPlayer, bool showSimplePlayer);

} // namespace YandexIO
