#pragma once

#include <alice/megamind/protos/common/device_state.pb.h>
#include <alice/megamind/protos/common/experiments.pb.h>
#include <alice/megamind/protos/guest/enrollment_headers.pb.h>

#include <yandex_io/sdk/interfaces/i_capability.h>

#include <optional>
#include <unordered_set>

namespace YandexIO {

    class IDeviceStateCapability: public ICapability {
    public:
        virtual ~IDeviceStateCapability();

        virtual void setBluetoothState(const NAlice::TDeviceState::TBluetooth& state) = 0;
        virtual void setAudioPlayerState(const NAlice::TDeviceState::TAudioPlayer& state) = 0;
        virtual void setMusicState(const NAlice::TDeviceState::TMusic& state) = 0;
        virtual void setRadioState(const google::protobuf::Struct& state) = 0;
        virtual void setLastWatched(const NAlice::TDeviceState::TLastWatched& state) = 0;
        virtual void setVideoState(const NAlice::TDeviceState::TVideo& state) = 0;
        virtual void setRcuState(const NAlice::TDeviceState::TRcuState& state) = 0;
        virtual void setScreenState(const NAlice::TDeviceState::TScreen& state) = 0;
        virtual void setMultiroomState(const NAlice::TDeviceState::TMultiroom& state) = 0;
        virtual void setPackagesState(const NAlice::TDeviceState::TPackagesState& state) = 0;
        virtual void setIsTvPluggedIn(bool isTvPluggedIn) = 0;
        virtual void setICalendar(const TString& ical) = 0;
        virtual void setAlarmState(const NAlice::TDeviceState::TAlarmState& state) = 0;
        virtual void setTimersState(const NAlice::TDeviceState::TTimers& state) = 0;
        virtual void setMicsMuted(bool muted) = 0;
        virtual void setBattery(const NAlice::TDeviceState::TBattery& battery) = 0;

        virtual void addSupportedFeature(const TString& feature) = 0;
        virtual void setSupportedFeatures(const std::unordered_set<TString>& features) = 0;
        virtual void setUnsupportedFeatures(const std::unordered_set<TString>& features) = 0;
        virtual void setExperiments(const NAlice::TExperimentsProto& experiments) = 0;
        virtual void setEnrollmentHeaders(const NAlice::TEnrollmentHeaders& enrollmentHeaders) = 0;
        virtual void setEnvironmentDeviceInfo(const NAlice::TEnvironmentDeviceInfo& deviceInfo) = 0;
        virtual void setNetworkState(const NAlice::TDeviceStateCapability::TState::TNetworkState& state) = 0;
        virtual void setVolumeState(bool soundMuted, int soundLevel, std::optional<int> soundMaxLevel) = 0;
    };

} // namespace YandexIO
