#pragma once

#include <yandex_io/capabilities/device_state/interfaces/i_device_state_capability.h>

#include <yandex_io/libs/threading/i_callback_queue.h>

#include <yandex_io/sdk/private/remoting/i_remote_object.h>
#include <yandex_io/sdk/private/remoting/i_remoting_registry.h>

#include <unordered_set>

namespace YandexIO {

    class DeviceStateCapabilityProxy: public IDeviceStateCapability,
                                      public YandexIO::IRemoteObject,
                                      public std::enable_shared_from_this<DeviceStateCapabilityProxy> {
    public:
        DeviceStateCapabilityProxy(std::weak_ptr<IRemotingRegistry> remotingRegistry,
                                   std::shared_ptr<quasar::ICallbackQueue> worker);
        ~DeviceStateCapabilityProxy();

        void init();

        /// IRemoteObject
        void handleRemotingMessage(const quasar::proto::Remoting& message,
                                   std::shared_ptr<IRemotingConnection> connection) override;
        void handleRemotingConnect(std::shared_ptr<IRemotingConnection> connection) override;

        // ICapability
        NAlice::TCapabilityHolder getState() const override;
        std::shared_ptr<IDirectiveHandler> getDirectiveHandler() override;
        void addListener(std::weak_ptr<IListener> wlistener) override;
        void removeListener(std::weak_ptr<IListener> wlistener) override;

        // IDeviceStateCapability
        void setBluetoothState(const NAlice::TDeviceState::TBluetooth& state) override;
        void setAudioPlayerState(const NAlice::TDeviceState::TAudioPlayer& state) override;
        void setMusicState(const NAlice::TDeviceState::TMusic& state) override;
        void setRadioState(const google::protobuf::Struct& state) override;
        void setLastWatched(const NAlice::TDeviceState::TLastWatched& state) override;
        void setVideoState(const NAlice::TDeviceState::TVideo& state) override;
        void setRcuState(const NAlice::TDeviceState::TRcuState& state) override;
        void setScreenState(const NAlice::TDeviceState::TScreen& state) override;
        void setMultiroomState(const NAlice::TDeviceState::TMultiroom& state) override;
        void setPackagesState(const NAlice::TDeviceState::TPackagesState& state) override;
        void setIsTvPluggedIn(bool isTvPluggedIn) override;
        void setICalendar(const TString& ical) override;
        void setAlarmState(const NAlice::TDeviceState::TAlarmState& state) override;
        void setTimersState(const NAlice::TDeviceState::TTimers& state) override;
        void setNetworkState(const NAlice::TDeviceStateCapability::TState::TNetworkState& state) override;
        void setMicsMuted(bool muted) override;
        void setVolumeState(bool soundMuted, int soundLevel, std::optional<int> soundMaxLevel) override;
        void setBattery(const NAlice::TDeviceState::TBattery& battery) override;

        void addSupportedFeature(const TString& feature) override;
        void setSupportedFeatures(const std::unordered_set<TString>& features) override;
        void setUnsupportedFeatures(const std::unordered_set<TString>& features) override;
        void setExperiments(const NAlice::TExperimentsProto& experiments) override;
        void setEnrollmentHeaders(const NAlice::TEnrollmentHeaders& enrollmentHeaders) override;
        void setEnvironmentDeviceInfo(const NAlice::TEnvironmentDeviceInfo& deviceInfo) override;

    private:
        void onConnected();
        void sendState();

    private:
        const std::shared_ptr<quasar::ICallbackQueue> callbackQueue_;
        const std::string remoteObjectId_;
        std::shared_ptr<IRemotingConnection> connection_;

        bool isConnected_ = false;
        NAlice::TDeviceStateCapability::TState deviceState_;

        std::unordered_set<TString> supportedFeaturesToAdd_;
        std::optional<std::unordered_set<TString>> supportedFeaturesToSet_;
        std::optional<std::unordered_set<TString>> unsupportedFeatures_;
    };

} // namespace YandexIO
