#pragma once

#include "interfaces/i_file_player_capability.h"

#include <yandex_io/libs/threading/i_callback_queue.h>

#include <yandex_io/sdk/private/remoting/i_remote_object.h>
#include <yandex_io/sdk/private/remoting/i_remoting_registry.h>

#include <string>
#include <unordered_map>
#include <list>

namespace YandexIO {

    class FilePlayerCapabilityProxy: public IFilePlayerCapability,
                                     public YandexIO::IRemoteObject,
                                     public std::enable_shared_from_this<FilePlayerCapabilityProxy> {
    public:
        FilePlayerCapabilityProxy(std::weak_ptr<IRemotingRegistry> remotingRegistry,
                                  std::shared_ptr<quasar::ICallbackQueue> worker);
        ~FilePlayerCapabilityProxy();

        void init();

        /// IFilePlayerCapability implementation
        void playSoundFile(const std::string& fileName,
                           std::optional<quasar::proto::AudioChannel> channel,
                           std::optional<PlayParams> params = std::nullopt,
                           std::shared_ptr<IPlaySoundFileListener> listener = nullptr) override;

        void stopSoundFile(const std::string& fileName) override;

        /// IRemoteObject implementation
        void handleRemotingMessage(const quasar::proto::Remoting& message,
                                   std::shared_ptr<IRemotingConnection> connection) override;

        void handleRemotingConnect(std::shared_ptr<IRemotingConnection> connection) override;

    private:
        using ProtoFPCMethod = quasar::proto::Remoting::FilePlayerCapabilityMethod;

        void handleRemotingMessageImpl(const quasar::proto::Remoting& message);

        void sendQueuedMethods();

        void sendOrEnqueueMethod(ProtoFPCMethod method);
        void sendMethod(ProtoFPCMethod method);

    private:
        const std::shared_ptr<quasar::ICallbackQueue> callbackQueue_;
        const std::string remoteObjectId_;

        bool isConnected_ = false;
        std::list<ProtoFPCMethod> queuedMethods_;
        std::shared_ptr<IRemotingConnection> connection_;

        std::unordered_map<std::string, std::shared_ptr<IPlaySoundFileListener>> listenerByRequestId_;
    };

} // namespace YandexIO
