#pragma once

#include <yandex_io/protos/model_objects.pb.h>
#include <yandex_io/protos/quasar_proto.pb.h>

namespace YandexIO {
    class IPlaySoundFileListener {
    public:
        virtual ~IPlaySoundFileListener();

        virtual void onStarted() = 0;
        virtual void onCompleted() = 0;
    };

    class IFilePlayerCapability {
    public:
        virtual ~IFilePlayerCapability();

        struct PlayParams {
            bool playLooped = false;
            uint32_t playTimes = 1;
            std::string requestId;
            std::string parentRequestId;
        };
        virtual void playSoundFile(const std::string& fileName,
                                   std::optional<quasar::proto::AudioChannel> channel,
                                   std::optional<PlayParams> params = std::nullopt,
                                   std::shared_ptr<IPlaySoundFileListener> listener = nullptr) = 0;

        virtual void stopSoundFile(const std::string& fileName) = 0;
    };

} // namespace YandexIO
