#include "play_sound_file_listener.h"

using namespace YandexIO;

PlaySoundFileListener::PlaySoundFileListener(std::function<void()> onStarted, std::function<void()> onCompleted)
    : onStarted_(std::move(onStarted))
    , onCompleted_(std::move(onCompleted))
{
}

PlaySoundFileListener::~PlaySoundFileListener() = default;

void PlaySoundFileListener::onStarted() {
    if (onStarted_) {
        onStarted_();
    }
}

void PlaySoundFileListener::onCompleted() {
    if (onCompleted_) {
        onCompleted_();
    }
}
