#pragma once

#include <cstdint>

namespace YandexIO {

    class IPlaybackControlCapability {
    public:
        virtual ~IPlaybackControlCapability();

        virtual void play() = 0;
        virtual void pause() = 0;
        virtual void togglePlayPause(bool canRequestMusic) = 0;
        virtual void rewind(std::uint32_t time) = 0;
        virtual void like() = 0;
        virtual void dislike() = 0;
        virtual void next() = 0;
        virtual void prev() = 0;
    };

} // namespace YandexIO
